/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.calendar;

import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class VWCalendarControlDialog
extends VWModalDialog
implements ActionListener,
ItemListener {
    public static final int STATUS_CANCEL = 0;
    public static final int STATUS_OK = 1;
    public static final int CALENDAR_ONLY = 100;
    public static final int TIME_ONLY = 101;
    public static final int CALENDAR_TIME = 102;
    protected static final Logger m_logger = Logger.getLogger("filenet.vw.toolkit.utils.uicontrols");
    protected static final String m_className = "filenet.vw.toolkit.utils.uicontrols.VWCalendarControlDialog";
    private String[] daysOfTheWeek = new String[]{VWResource.s_sundayAbb, VWResource.s_mondayAbb, VWResource.s_tuesdayAbb, VWResource.s_wednesdayAbb, VWResource.s_thursdayAbb, VWResource.s_fridayAbb, VWResource.s_saturdayAbb};
    private int m_closeStatus = 0;
    private GregorianCalendar m_calendar = null;
    private int m_initialYear = 0;
    private int m_year = 0;
    private int m_month = 0;
    private int m_dayOfMonth = 0;
    private int m_hour = 0;
    private int m_minute = 0;
    private int m_ampm = 0;
    private boolean m_bLeapYear = false;
    private int m_1stDayOfWeek = 0;
    private int m_monthStartDay = 0;
    private int m_minYear = 1980;
    private int m_maxYear = 2050;
    private Date m_initDate = null;
    private JButton m_prevMonth = null;
    private JButton m_nextMonth = null;
    private JLabel m_monthYear = null;
    private JButton[] m_dates = new JButton[42];
    private JComboBox m_monthCombo = null;
    private DefaultComboBoxModel m_monthModel = null;
    private VWMonthRenderer m_monthRenderer = new VWMonthRenderer();
    private JComboBox m_yearCombo = null;
    private DefaultComboBoxModel m_yearModel = null;
    private JComboBox m_hourCombo = null;
    private JComboBox m_minuteCombo = null;
    private JComboBox m_ampmCombo = null;
    private VWAMPMRenderer m_ampmRenderer = new VWAMPMRenderer();
    private JButton m_selectedDateButton = null;
    private JPanel m_calendarPanel = new JPanel();
    private int m_cellWidth = 20;
    private int m_cellHeight = 20;
    private Dimension m_preferredCalendarPanelSize = null;
    private JPanel m_monthYearPanel = new JPanel();
    private JPanel m_timePanel = new JPanel();
    private JPanel m_buttonPanel = new JPanel();
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private boolean m_bUpdatingControls = false;
    private Locale m_theLocale = Locale.getDefault();
    private ComponentOrientation m_cOrient = ComponentOrientation.getOrientation(this.m_theLocale);
    private boolean m_cOrientIsLeftToRight = this.m_cOrient.isLeftToRight();
    private SimpleDateFormat m_dateFormat = new SimpleDateFormat();
    private String m_datePattern = this.m_dateFormat.toPattern();
    private boolean m_bIs24HourFormat = false;

    public VWCalendarControlDialog(Frame parent) {
        super(parent);
        try {
            this.init(102);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWCalendarControlDialog(Frame parent, int flag) {
        super(parent);
        try {
            this.init(flag);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWCalendarControlDialog(Frame parent, int flag, String initDateTime) {
        super(parent);
        try {
            if (initDateTime != null && initDateTime.length() > 0) {
                this.m_initDate = VWDateTimeFormat.getDateObject(initDateTime);
            }
            this.init(flag);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWCalendarControlDialog(Frame parent, int flag, Date initDateTime) {
        super(parent);
        try {
            this.m_initDate = initDateTime;
            this.init(flag);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getCloseStatus() {
        return this.m_closeStatus;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_prevMonth) {
            this.onPreviousMonth();
        } else if (object == this.m_nextMonth) {
            this.onNextMonth();
        } else if (object == this.m_okButton) {
            this.onOkButton(event);
        } else if (object == this.m_cancelButton) {
            this.onCancelButton(event);
        } else {
            this.onDateButton(event);
        }
        this.m_okButton.requestFocus();
    }

    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getSource();
        if (obj == null) {
            return;
        }
        if (obj == this.m_monthCombo && !this.m_bUpdatingControls && (obj = this.m_monthCombo.getSelectedItem()) != null && obj instanceof Integer) {
            this.m_month = (Integer)obj;
            this.m_bUpdatingControls = true;
            this.updateCalendarControls();
            this.m_bUpdatingControls = false;
        }
        if (obj == this.m_yearCombo && !this.m_bUpdatingControls) {
            obj = this.m_yearCombo.getSelectedItem();
            if (obj != null && obj instanceof Integer) {
                this.m_year = (Integer)obj;
                this.m_bUpdatingControls = true;
                this.updateCalendarControls();
                this.m_bUpdatingControls = false;
            }
        } else if (obj == this.m_hourCombo) {
            obj = this.m_hourCombo.getSelectedItem();
            if (obj != null && obj instanceof Integer) {
                this.m_hour = (Integer)obj;
            }
        } else if (obj == this.m_minuteCombo) {
            obj = this.m_minuteCombo.getSelectedItem();
            if (obj != null && obj instanceof Integer) {
                this.m_minute = (Integer)obj;
            }
        } else if (obj == this.m_ampmCombo && (obj = this.m_ampmCombo.getSelectedItem()) != null && obj instanceof Integer) {
            this.m_ampm = (Integer)obj;
        }
    }

    public Date getDate() {
        if (this.m_closeStatus == 0) {
            return null;
        }
        if (this.m_calendar != null) {
            return this.m_calendar.getTime();
        }
        return null;
    }

    public GregorianCalendar getGregorianCalendarDate() {
        return this.m_calendar;
    }

    private void init(int flag) {
        m_logger.entering(m_className, "init");
        try {
            this.m_calendar = new GregorianCalendar();
            if (this.m_initDate != null) {
                this.m_calendar.setTime(this.m_initDate);
            }
            this.m_year = this.m_calendar.get(1);
            this.m_bLeapYear = this.m_calendar.isLeapYear(this.m_year);
            this.m_initialYear = this.m_year;
            this.m_month = this.m_calendar.get(2);
            this.m_dayOfMonth = this.m_calendar.get(5);
            this.m_1stDayOfWeek = this.m_calendar.getFirstDayOfWeek();
            this.m_minute = this.m_calendar.get(12);
            this.m_ampm = this.m_calendar.get(9);
            int n = this.m_hour = this.m_calendar.get(10) == 0 ? 12 : this.m_calendar.get(10);
            if (this.m_datePattern.indexOf(72) >= 0) {
                this.m_bIs24HourFormat = true;
                if (this.m_ampm == 1 && this.m_hour < 12) {
                    this.m_hour += 12;
                }
            }
            if (m_logger.isFinest()) {
                m_logger.finest(m_className, "init", "date time pattern=\"" + this.m_datePattern + "\", first day of week" + this.m_1stDayOfWeek + ", hour format:" + (this.m_bIs24HourFormat ? 24 : 12));
                m_logger.finest(m_className, "init", "language orientation isLeftToRight:" + this.m_cOrientIsLeftToRight);
            }
            Dimension dim = null;
            dim = VWStringUtils.stringToDimension(flag == 101 ? "235,115" : "235,335");
            if (dim == null) {
                dim = new Dimension(210, 300);
            }
            this.setSize(dim);
            this.setTitle(VWResource.s_calendar);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.setupCalendarPanel();
            this.setupMonthYearPanel();
            this.setupTimePanel();
            this.setupButtonPanel();
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)this.m_monthYearPanel, "First");
            mainPanel.add((Component)this.m_calendarPanel, "Center");
            mainPanel.add((Component)this.m_timePanel, "Last");
            this.getContentPane().add((Component)mainPanel, "Center");
            this.getContentPane().add((Component)this.m_buttonPanel, "Last");
            this.getRootPane().setDefaultButton(this.m_okButton);
            switch (flag) {
                case 100: {
                    this.m_timePanel.setVisible(false);
                    break;
                }
                case 101: {
                    this.m_calendarPanel.setVisible(false);
                    this.m_monthYearPanel.setVisible(false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        m_logger.exiting(m_className, "init");
    }

    private void setupButtonPanel() {
        this.m_okButton = new JButton(VWResource.s_ok);
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        this.m_buttonPanel = new JPanel();
        this.m_buttonPanel.setLayout(new FlowLayout());
        this.m_buttonPanel.add(this.m_okButton);
        this.m_buttonPanel.add(this.m_cancelButton);
        this.m_okButton.addActionListener(this);
        this.m_cancelButton.addActionListener(this);
    }

    private void setupCalendarPanel() {
        int dw;
        GridBagConstraints c = new GridBagConstraints();
        this.m_calendarPanel.setLayout(new GridBagLayout());
        this.m_calendarPanel.setBackground(Color.white);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(4, 4, 0, 0);
        c.anchor = 10;
        c.fill = 1;
        for (dw = this.m_1stDayOfWeek; dw <= 7; ++dw) {
            this.m_calendarPanel.add((Component)new JLabel(this.getDayOfWeekString(dw)), c);
            ++c.gridx;
        }
        for (dw = 1; dw < this.m_1stDayOfWeek; ++dw) {
            this.m_calendarPanel.add((Component)new JLabel(this.getDayOfWeekString(dw)), c);
            ++c.gridx;
        }
        this.m_calendarPanel.add(Box.createVerticalStrut(this.m_cellHeight), c);
        Dimension dim = VWStringUtils.stringToDimension("20, 20");
        if (dim == null) {
            dim = new Dimension(20, 20);
        }
        this.m_cellWidth = (int)dim.getWidth();
        this.m_cellHeight = (int)dim.getHeight();
        int i = 0;
        while (i < this.m_dates.length) {
            ++c.gridy;
            c.gridx = 0;
            while (i < this.m_dates.length && c.gridx < 7) {
                JButton date = new JButton(Integer.toString(i));
                date.setVisible(true);
                date.setBorder(null);
                date.setBackground(Color.white);
                date.setForeground(Color.black);
                this.m_dates[i] = date;
                this.m_calendarPanel.add((Component)date, c);
                date.addActionListener(this);
                ++i;
                ++c.gridx;
            }
            this.m_calendarPanel.add(Box.createVerticalStrut(this.m_cellHeight), c);
            ++c.gridx;
        }
        ++c.gridy;
        c.gridx = 0;
        while (c.gridx < 7) {
            this.m_calendarPanel.add(Box.createHorizontalStrut(this.m_cellWidth), c);
            ++c.gridx;
        }
        c.gridx = 0;
        this.updateCalendarControls();
        this.m_calendarPanel.setBorder(BorderFactory.createEtchedBorder(Color.black, Color.gray));
        this.m_calendarPanel.setSize(this.m_preferredCalendarPanelSize);
    }

    private void updateCalendarControls() {
        int numberOfDays = 0;
        int offset = 0;
        GregorianCalendar firstDayOfTheMonth = new GregorianCalendar(this.m_year, this.m_month, 1);
        this.m_monthStartDay = firstDayOfTheMonth.get(7);
        this.m_bLeapYear = this.m_calendar.isLeapYear(this.m_year);
        offset = this.m_monthStartDay - this.m_1stDayOfWeek;
        if (offset < 0) {
            offset = 7 - this.m_1stDayOfWeek + this.m_monthStartDay;
        }
        switch (this.m_month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                numberOfDays = 31;
                break;
            }
            case 1: {
                if (this.m_bLeapYear) {
                    numberOfDays = 29;
                    break;
                }
                numberOfDays = 28;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                numberOfDays = 30;
            }
        }
        if (this.m_dayOfMonth > numberOfDays) {
            this.m_dayOfMonth = numberOfDays;
        }
        int i = 0;
        for (int j = 0; i < this.m_dates.length && j < offset; ++i, ++j) {
            this.m_dates[i].setText(null);
            this.m_dates[i].setEnabled(false);
            this.m_dates[i].removeActionListener(this);
            this.m_dates[i].setBorder(null);
        }
        for (int date = 1; i < this.m_dates.length && date <= numberOfDays; ++i, ++date) {
            this.m_dates[i].setText(Integer.toString(date));
            this.m_dates[i].setEnabled(true);
            this.m_dates[i].removeActionListener(this);
            this.m_dates[i].addActionListener(this);
            if (date == this.m_dayOfMonth) {
                this.m_dates[i].setBorder(BorderFactory.createEtchedBorder(Color.black, Color.gray));
                continue;
            }
            this.m_dates[i].setBorder(null);
        }
        int numberOfRows = i / 7;
        while (i < this.m_dates.length) {
            this.m_dates[i].setText(null);
            this.m_dates[i].setEnabled(false);
            this.m_dates[i].removeActionListener(this);
            this.m_dates[i].setBorder(null);
            ++i;
        }
        int width = 32 + this.m_cellWidth * 7;
        int height = 4 + (this.m_cellHeight * numberOfRows + 1);
        this.m_preferredCalendarPanelSize = new Dimension(width, height);
    }

    private void setupMonthYearPanel() {
        if (this.m_cOrientIsLeftToRight) {
            this.m_prevMonth = VWImageLoader.createIconButton("prev.gif", VWResource.s_previousMonth);
            this.m_nextMonth = VWImageLoader.createIconButton("next.gif", VWResource.s_nextMonth);
        } else {
            this.m_prevMonth = VWImageLoader.createIconButton("next.gif", VWResource.s_previousMonth);
            this.m_nextMonth = VWImageLoader.createIconButton("prev.gif", VWResource.s_nextMonth);
        }
        this.m_prevMonth.setBorder(null);
        this.m_prevMonth.addActionListener(this);
        this.m_nextMonth.setBorder(null);
        this.m_nextMonth.addActionListener(this);
        Integer[] months = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11)};
        this.m_monthModel = new DefaultComboBoxModel<Integer>(months);
        this.m_monthCombo = new JComboBox(this.m_monthModel);
        this.m_monthCombo.setRenderer(this.m_monthRenderer);
        this.m_monthCombo.addItemListener(this);
        Dimension dim = VWStringUtils.stringToDimension("1980, 2050");
        if (dim == null) {
            dim = new Dimension(1980, 2050);
        }
        this.m_minYear = (int)dim.getWidth();
        this.m_maxYear = (int)dim.getHeight();
        Integer[] years = new Integer[this.m_maxYear - this.m_minYear + 1];
        for (int i = this.m_minYear; i <= this.m_maxYear; ++i) {
            years[i - this.m_minYear] = new Integer(i);
        }
        this.m_yearModel = new DefaultComboBoxModel<Integer>(years);
        this.m_yearCombo = new JComboBox(this.m_yearModel);
        this.m_yearCombo.addItemListener(this);
        this.m_yearCombo.setRenderer(new VWLabelListCellRenderer());
        this.m_monthYearPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.insets = new Insets(4, 4, 4, 4);
        if (this.m_cOrientIsLeftToRight) {
            this.m_monthYearPanel.add((Component)this.m_prevMonth, c);
        } else {
            this.m_monthYearPanel.add((Component)this.m_nextMonth, c);
        }
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 23;
        c.fill = 1;
        c.insets = new Insets(4, 4, 4, 4);
        int idxM = this.m_datePattern.indexOf(77);
        int idxY = this.m_datePattern.indexOf(121);
        if (idxM >= 0 && idxY >= 0 && idxY < idxM) {
            this.m_monthYearPanel.add((Component)this.m_yearCombo, c);
            c.gridx = 4;
            c.gridwidth = 1;
            this.m_monthYearPanel.add((Component)this.m_monthCombo, c);
        } else {
            this.m_monthYearPanel.add((Component)this.m_monthCombo, c);
            c.gridx = 4;
            c.gridwidth = 1;
            this.m_monthYearPanel.add((Component)this.m_yearCombo, c);
        }
        c.gridx = 5;
        c.anchor = 22;
        if (this.m_cOrientIsLeftToRight) {
            this.m_monthYearPanel.add((Component)this.m_nextMonth, c);
        } else {
            this.m_monthYearPanel.add((Component)this.m_prevMonth, c);
        }
        this.updateMonthYearControls();
    }

    private void setupTimePanel() {
        int i;
        Integer[] hours;
        if (this.m_bIs24HourFormat) {
            hours = new Integer[24];
            for (i = 0; i < hours.length; ++i) {
                hours[i] = new Integer(i);
            }
        } else {
            hours = new Integer[12];
            for (i = 0; i < hours.length; ++i) {
                hours[i] = new Integer(i + 1);
            }
        }
        this.m_hourCombo = new JComboBox<Integer>(hours);
        this.m_hourCombo.setRenderer(new VWLabelListCellRenderer());
        this.m_hourCombo.addItemListener(this);
        Integer[] minutes = new Integer[60];
        for (int i2 = 0; i2 < minutes.length; ++i2) {
            minutes[i2] = new Integer(i2);
        }
        this.m_minuteCombo = new JComboBox<Integer>(minutes);
        this.m_minuteCombo.setRenderer(new VWHourMinutesRenderer());
        this.m_minuteCombo.addItemListener(this);
        Integer[] ampm = new Integer[]{new Integer(0), new Integer(1)};
        this.m_ampmCombo = new JComboBox<Integer>(ampm);
        this.m_ampmCombo.setRenderer(this.m_ampmRenderer);
        this.m_ampmCombo.addItemListener(this);
        this.m_timePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        c.fill = 1;
        c.insets = new Insets(4, 4, 4, 4);
        if (!this.m_bIs24HourFormat && !this.m_cOrientIsLeftToRight) {
            this.m_timePanel.add((Component)this.m_ampmCombo, c);
            ++c.gridx;
        }
        if (this.m_cOrientIsLeftToRight) {
            this.m_timePanel.add((Component)this.m_hourCombo, c);
            ++c.gridx;
            this.m_timePanel.add((Component)new JLabel(":"), c);
            ++c.gridx;
            this.m_timePanel.add((Component)this.m_minuteCombo, c);
        } else {
            this.m_timePanel.add((Component)this.m_minuteCombo, c);
            ++c.gridx;
            this.m_timePanel.add((Component)new JLabel(":"), c);
            ++c.gridx;
            this.m_timePanel.add((Component)this.m_hourCombo, c);
        }
        if (!this.m_bIs24HourFormat && this.m_cOrientIsLeftToRight) {
            ++c.gridx;
            this.m_timePanel.add((Component)this.m_ampmCombo, c);
        }
        this.m_ampmCombo.addItemListener(this);
        this.updateTimeControls();
    }

    private void updateMonthYearControls() {
        int i;
        Object obj = null;
        for (i = 0; i < this.m_monthModel.getSize(); ++i) {
            obj = this.m_monthModel.getElementAt(i);
            if (obj == null || !(obj instanceof Integer) || (Integer)obj != this.m_month) continue;
            this.m_monthCombo.setSelectedItem(obj);
        }
        for (i = 0; i < this.m_yearModel.getSize(); ++i) {
            obj = this.m_yearModel.getElementAt(i);
            if (obj == null || !(obj instanceof Integer) || (Integer)obj != this.m_year) continue;
            this.m_yearCombo.setSelectedItem(obj);
        }
    }

    private void updateTimeControls() {
        if (this.m_bIs24HourFormat) {
            this.m_hourCombo.setSelectedIndex(this.m_hour);
        } else {
            this.m_hourCombo.setSelectedIndex(this.m_hour - 1);
        }
        this.m_minuteCombo.setSelectedIndex(this.m_minute);
        if (this.m_ampm == 0) {
            this.m_ampmCombo.setSelectedIndex(0);
        } else {
            this.m_ampmCombo.setSelectedIndex(1);
        }
    }

    private void onPreviousMonth() {
        --this.m_month;
        if (this.m_month < 0) {
            this.m_month = 11;
            --this.m_year;
            if (this.m_year < this.m_minYear) {
                this.m_minYear = this.m_year;
                this.m_yearModel.insertElementAt(new Integer(this.m_year), 0);
            }
        }
        this.m_bUpdatingControls = true;
        this.updateMonthYearControls();
        this.updateCalendarControls();
        this.m_bUpdatingControls = false;
    }

    private void onNextMonth() {
        ++this.m_month;
        if (this.m_month > 11) {
            this.m_month = 0;
            ++this.m_year;
            if (this.m_year > this.m_maxYear) {
                this.m_maxYear = this.m_year;
                this.m_yearModel.addElement(new Integer(this.m_year));
            }
        }
        this.m_bUpdatingControls = true;
        this.updateMonthYearControls();
        this.updateCalendarControls();
        this.m_bUpdatingControls = false;
    }

    private void onDateButton(ActionEvent event) {
        Object obj = event.getSource();
        for (int i = 0; i < this.m_dates.length; ++i) {
            if (obj == this.m_dates[i]) {
                this.m_dates[i].setBorder(BorderFactory.createEtchedBorder(Color.black, Color.gray));
                this.m_dayOfMonth = Integer.parseInt(this.m_dates[i].getText());
                continue;
            }
            this.m_dates[i].setBorder(null);
        }
    }

    private void onOkButton(ActionEvent event) {
        int hour = this.m_hour;
        if (!this.m_bIs24HourFormat) {
            if (hour == 12) {
                hour = 0;
            }
            if (this.m_ampm == 1) {
                hour += 12;
            }
        }
        this.m_calendar = new GregorianCalendar(this.m_year, this.m_month, this.m_dayOfMonth, hour, this.m_minute);
        this.setVisible(false);
        this.m_closeStatus = 1;
    }

    private void onCancelButton(ActionEvent event) {
        this.m_calendar = null;
        this.setVisible(false);
        this.m_closeStatus = 0;
    }

    private String getMonthAndYearString(int month, int year) {
        String monthString = this.getMonthString(month);
        String yearString = Integer.toString(year);
        return VWResource.s_montheAndYear.toString(monthString, yearString);
    }

    private String getMonthString(int month) {
        switch (month) {
            case 0: {
                return VWResource.s_january;
            }
            case 1: {
                return VWResource.s_february;
            }
            case 2: {
                return VWResource.s_march;
            }
            case 3: {
                return VWResource.s_april;
            }
            case 4: {
                return VWResource.s_may;
            }
            case 5: {
                return VWResource.s_june;
            }
            case 6: {
                return VWResource.s_july;
            }
            case 7: {
                return VWResource.s_august;
            }
            case 8: {
                return VWResource.s_september;
            }
            case 9: {
                return VWResource.s_october;
            }
            case 10: {
                return VWResource.s_november;
            }
            case 11: {
                return VWResource.s_december;
            }
        }
        return null;
    }

    private String getDayOfWeekString(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return VWResource.s_sundayAbb;
            }
            case 2: {
                return VWResource.s_mondayAbb;
            }
            case 3: {
                return VWResource.s_tuesdayAbb;
            }
            case 4: {
                return VWResource.s_wednesdayAbb;
            }
            case 5: {
                return VWResource.s_thursdayAbb;
            }
            case 6: {
                return VWResource.s_fridayAbb;
            }
            case 7: {
                return VWResource.s_saturdayAbb;
            }
        }
        return null;
    }

    private String getAMPMString(int ampm) {
        switch (ampm) {
            case 0: {
                return VWResource.s_am;
            }
            case 1: {
                return VWResource.s_pm;
            }
        }
        return null;
    }

    private class VWHourMinutesRenderer
    extends JLabel
    implements ListCellRenderer {
        private VWHourMinutesRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(list.getFont());
            this.setEnabled(list.isEnabled());
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null && value instanceof Integer) {
                String strValue = value.toString();
                this.setText(strValue.length() == 1 ? "0" + strValue : strValue);
            } else {
                this.setText(null);
            }
            return this;
        }
    }

    private class VWAMPMRenderer
    extends JLabel
    implements ListCellRenderer {
        private VWAMPMRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(list.getFont());
            this.setEnabled(list.isEnabled());
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null && value instanceof Integer) {
                int month = (Integer)value;
                this.setText(VWCalendarControlDialog.this.getAMPMString(month));
            } else {
                this.setText(null);
            }
            return this;
        }
    }

    private class VWMonthRenderer
    extends JLabel
    implements ListCellRenderer {
        private VWMonthRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(list.getFont());
            this.setEnabled(list.isEnabled());
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null && value instanceof Integer) {
                int month = (Integer)value;
                this.setText(VWCalendarControlDialog.this.getMonthString(month));
            } else {
                this.setText(null);
            }
            return this;
        }
    }
}

